<?php

class EWRporta_Install
{
	public static function installCode()
	{
		$db = XenForo_Application::get('db');

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_cache` (
				`module_name`		varchar(100)		NOT NULL,
				`module_date`		int(10) unsigned	NOT NULL,
				`module_settings`	mediumtext			NOT NULL,
				UNIQUE KEY (`module_name`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_modules` (
				`module_name`		varchar(100)												NOT NULL,
				`module_order`		int(10) unsigned											NOT NULL DEFAULT '0',
				`module_position`	enum('top','bottom','left','center','right','disabled')		NOT NULL DEFAULT 'disabled',
				`module_cache`		varchar(255)												NOT NULL DEFAULT '+10 minutes',
				`module_show`		varchar(255)												NOT NULL,
				`module_hide`		varchar(255)												NOT NULL,
				`module_locked`		int(1) unsigned												NOT NULL DEFAULT '0',
				PRIMARY KEY (`module_name`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");
 		$db->query("ALTER IGNORE TABLE `EWRporta_modules` CHANGE `module_position` `module_position` ENUM('top','bottom','left','center','right','disabled') NOT NULL DEFAULT 'disabled'");
		self::addColumnIfNotExist($db, "EWRporta_modules", "module_cache", "varchar(255) NOT NULL DEFAULT '+10 minutes'");
		self::addColumnIfNotExist($db, "EWRporta_modules", "module_show", "varchar(255) NOT NULL");
		self::addColumnIfNotExist($db, "EWRporta_modules", "module_hide", "varchar(255) NOT NULL");
		self::addColumnIfNotExist($db, "EWRporta_modules", "module_locked", "int(1) unsigned NOT NULL DEFAULT '0'");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_promotes` (
				`thread_id`			int(10) unsigned	NOT NULL,
				`promote_date`		int(10) unsigned	NOT NULL,
				PRIMARY KEY (`thread_id`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");

 		$db->query("
			CREATE TABLE IF NOT EXISTS `EWRporta_settings` (
				`module_name`		varchar(100)	NOT NULL,
				`setting_name`		varchar(100)	NOT NULL,
				`setting_value`		varchar(255)	NOT NULL,
				`setting_desc`		varchar(255)	NOT NULL,
				`setting_format`	varchar(255)	NOT NULL,
				PRIMARY KEY (`setting_name`)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		");

		if ($handle = opendir($xmlDir = XenForo_Application::getInstance()->getRootDir().'/library/EWRporta/XML'))
		{
			while (false !== ($file = readdir($handle)))
			{
				if (strstr($file,'xml'))
				{
					XenForo_Model::create('EWRporta_Model_Modules')->importModule($xmlDir.'/'.$file);
				}
			}
			opendir($xmlDir);
		}

		return true;
	}

	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');

		$modules = XenForo_Model::create('EWRporta_Model_Modules')->getModules();

		foreach ($modules AS $module)
		{
			XenForo_Model::create('EWRporta_Model_Modules')->deleteModule($module);
		}

 		$db->query("
			DROP TABLE IF EXISTS
				`EWRporta_cache`,
				`EWRporta_modules`,
				`EWRporta_settings`
		");

		return true;
	}

	public static function addColumnIfNotExist($db, $table, $field, $attr)
	{
		if ($db->fetchRow('SHOW columns FROM `'.$table.'` WHERE Field = ?', $field))
		{
			return false;
		}
		
		return $db->query("ALTER TABLE `".$table."` ADD `".$field."` ".$attr);
	}
}